<?php

namespace App\Http\Controllers\Tamara;

use App\Http\Controllers\Controller;
use App\Models\Order;
use App\Models\Register_transaction;
use App\Payment\Tamara\Tamara;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\URL;

class TamaraController extends Controller
{
    public function failure_payment($id)
    {

        toastr()->warning('payment cancel !!!!!!!!!!');
        $order = Order::find($id);
        if ($order) {
            $order->payment_status = "failed";
            $order->save();
            return redirect()->route("home");
        } else {

            return redirect()->route("home");
        }
    }

    public function get_redirect_link(Request $request, $id_order)
    {



        if (! $request->hasValidSignature()) {
            return abort(401);
        }
        if ($id_order < 0) {
            toastr()->warning('اقل قيمة للدفع هي 100');
            return back();
        }


        $order = Order::findorfail($id_order);
        if ($order->total < 100) {
            toastr()->warning('اقل قيمة للدفع هي 100');
            return back();
        }
        if ($order->total > 4000) {
            toastr()->warning('اكبر قيمة للدفع هي 2000');
            return back();
        }


        $price = $order->total;

        $price = round($price, 2);






        $success_url = URL::signedRoute("processing_payment", $id_order);
        $failure_url = URL::signedRoute('failure_payment', $id_order);
        // dd($id_order);
        $tamara = new Tamara();

        $response = $tamara->get_payment_link($price, "SAR", $success_url, $failure_url,$id_order);
        $transaction_id = $response['order_id'];
        $out_link = $response['payment_link'];
        $register_transaction = Register_transaction::create([
            "uuid" => $transaction_id,
            "order_id" => $id_order
        ]);
        if ($register_transaction) {
            $order->register_transaction_id = $transaction_id;
            $order->save();
            return redirect()->to($out_link);
        } else {
            abort("404");
        }
    }
    public function processing_payment(Request $request, $id_order)
    {

       

        if (isset($request->paymentStatus) && $request->paymentStatus == 'approved') {


            $register_transaction = Register_transaction::where("order_id", "=", $id_order)->first();
            if ($register_transaction->status != "withdraw") {

                $register_transaction->status = "withdraw";
                $register_transaction->save();
                $tamara = new Tamara();
                $response_capture = $tamara->capture($register_transaction->uuid);

                $order = Order::findorfail($id_order);
                if ($response_capture == "done") {
                    $order->payment_status = "paid";
                    $order->save();
                    // dd($response_capture);

                    toastr()->success('تم الدفع بنجاح');

                   
               
                    // return redirect()->route('home');
                    return redirect()->route('account.index');
                } else {
                    toastr()->success('تم دفع المبلغ بنجاح');


                    return redirect()->route('home');
                }
            } else {
                toastr()->warning('جاري معالجة الطلب');


                return redirect()->route('home');
            }
        } else {
            toastr()->warning('جاري معالجة الطلب');


            return redirect()->route('home');
        }
    }
}
